# PUE · Agendamento do Cidadão — Demo Front‑End

Mock **React** sem build tools (JSX compilado no browser com **Babel**). Estilo **Tailwind** via CDN.

## Como correr
1. Descompacte o ZIP.
2. Abra `index.html` num browser moderno (Chrome, Edge, Firefox, Safari).
   - Requer acesso à internet para carregar React/ReactDOM, Babel e Tailwind via CDN.
3. Faça uma marcação na aba **Marcar** e depois veja em **Os meus agendamentos**.
4. Use **Exportar ICS** para descarregar o compromisso de calendário.

## Integração com produção (resumo)
- Trocar os métodos de `api` no `src/App.jsx` por chamadas REST reais (`/v1/services`, `/v1/slots`, `/v1/appointments`).
- Ligar **Keycloak (OIDC PKCE)** no topo para preencher dados do cidadão e sessão.
- Emitir telemetria **OpenTelemetry** e métricas (p95/erros) para **Grafana**.
