# PUE · Agendamento do Cidadão — Demo Front-End (v2)

Mock **React** sem build tools (JSX compilado no browser com **Babel**). Estilo **Tailwind** via CDN.

## Novidades
- **Login OIDC simulado** (modal) — guarda sessão no `localStorage`.
- **Alternância Demo/Reais** — botão no topo. Em modo **Reais**, as chamadas vão para a *Base URL* indicada e fazem **fallback** para Demo se falhar.
- **Base URL configurável** — na *sidebar* (guardada em `localStorage`).

## Como correr
1. Descompacte o ZIP.
2. Abra `index.html` num browser moderno (precisa de internet para CDNs).
3. (Opcional) Clique **Entrar** para simular autenticação (nome/e‑mail).
4. Use o botão **Dados Demo/Dados Reais** no topo para alternar o modo.
   - Em **Reais**, configure a **Base URL** (ex.: `http://localhost:8080`). Endpoints esperados: `/v1/services`, `/v1/sites`, `/v1/slots`, `/v1/appointments`.
   - Se a chamada falhar, o app **recorre a dados demo** automaticamente (com aviso na consola).
5. Faça uma marcação em **Marcar** e veja em **Os meus agendamentos**. Pode **Exportar ICS**.

## Integração (sugestão)
- Trocar os métodos de `makeApiReal` para apontarem ao gateway oficial (Envoy/Traefik).
- Ligar **Keycloak (OIDC PKCE)** real; preencher sessão com claims do *ID token*.
- Emitir OpenTelemetry (traces/metrics) e enviar p95/erros para **Grafana**.
